#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/user_menu'
require_relative '../../helper/modal'


describe '[Story# VAR-4406: Standardize Help Content]'  do
  include DriverUtility

  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @landing = Landing.new(@driver)
    @login = Login.new(@driver)
    @common = Common.new(@driver)
    @eula = Eula.new(@driver)
    @user_menu = UserMenuOption.new(@driver)
    @modal = Modal.new(@driver)
    APPOINTMENTS = "Appointments/Requests"
    @common.loginEndsOnHome(pw_redacted)

  end

  after(:all) do
    @driver.close
  end

  context 'AC#VAR-5427|TC#vAR-5428: Validate Help Content' do
    it "Login to VAR" do
      @landing.footerUserInfo_element.when_visible(TIME_OUT_LIMIT)
      @landing_appointments.primary_header_element.when_present(TIME_OUT_LIMIT)
      expect(@landing_appointments.primary_header).to eq(APPOINTMENTS)

    end

    it "Help option added in User Menu" do
      @user_menu.userMenu_element.when_visible(TIME_OUT_LIMIT)
      button_element = @driver.button(:id => 'user-menu-btn')
      execute_script("$(arguments[0]).click();",button_element)
      @user_menu.help_element.when_visible(TIME_OUT_LIMIT)
      expect( @user_menu.help_element.text).to eq("Help")
    end

    it "Should verify clicking on help opens the help Modal" do
      button_element = @driver.button(:id => 'help-btn')
      execute_script("$(arguments[0]).click();",button_element)
      @common.waitWhileSpinnerPresent
      @modal.modalTitle_element.when_present(TIME_OUT_LIMIT)
      expect(@modal.modalTitle).to eq("Help")

    end

    it "should verify the details on help modal" do
      expect(@modal.content).to eq("Help Desk (toll free): (877) 470-5947 Weekdays 7 a.m. - 7 p.m. (CT)\nIf you need assistance with the VA Appointments App, dial 1-877-470-5947 to speak with a Help Desk Representative. The Help Desk is open Monday - Friday from 7 a.m. to 7 p.m. CST. For TTY assistance, dial 711. If you have questions about your DS Logon account, visit mobile.DOMAIN.EX/dslogon or dial 1-800-983-0937 for assistance. Mobile App Training: Please visit mobile.DOMAIN.EX/appstore, and search for the VA Appointment App to access training materials.\nEmergencies\nIf you feel that your information may have been compromised, contact your local VA facility to obtain the contact information for your Privacy Officer. To identify your local VA facility, visit View VA Facilities, or by copying and pasting the following link into your browser: https://www.DOMAIN.EX/directory/guide/division.asp?dnum=1. Note that you should never use this app in an emergency situation. If you encounter an emergency, call your local medical center or dial 911. Veterans Crisis Line: 1-800-273-8255 Press 1.\nUser Guide")
    end

    it "should verify modile app training link" do
      expect(@user_menu.appStoreLink_element.text).to eq("mobile.DOMAIN.EX/appstore")
    end

    it "should verify view VA facilities link" do
      expect(@user_menu.facilityLocatorLink_element.text).to eq("View VA Facilities")
    end

    it "should verify user guide link" do
      expect(@user_menu.userGuideLink_element.text).to eq("User Guide")

    end

    it "should open the User guide when clicked" do
      #click the User Guide link
      @user_menu.userGuideLink
      switchWindowToWindowHandleLast
      expect(getCurrentURL).to include("app/modules/user-guide/Veteran_Appointment_Request_UG.pdf")
    end

    it "should display ok button on help modal" do
      switchWindowToWindowHandleFirst
      @modal.modalTitle_element.when_present(TIME_OUT_LIMIT)
      expect(@modal.buttons_elements[0].text).to eq("OK")
    end

    it "should close help modal once ok is clicked" do
      @modal.buttons_elements[0].click
      @landing_appointments.primary_header_element.when_present(TIME_OUT_LIMIT)
      expect(@landing_appointments.primary_header).to eq(APPOINTMENTS)
    end

  end
end









TTTT